<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Serializer;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Service\TravelTainmentService;

class RegionTreeTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    /**
     * checks if tt-regiontree should be updatet
     * success == regiontree is up to date
     * failure == regiontree and this test should be updated
     */
    public function testGetRegionTree()
    {
        $this->markTestSkipped('skip region tree');
        $ttService = new TravelTainmentService();

        $regionTreeRQ = new \Vtours\TTXmlWebService\Model\Request\SearchEngineRegionTreeRQ();
        $xml = $this->serializer->serialize($regionTreeRQ, 'xml');

        $regionTreeUrl = '/Search/Hotel/RegionTree';

        $response = $ttService->send($xml, $regionTreeUrl);
        $receivedOutput = $response->getBody()->getContents();


        $expectedOutput = <<<'TAG'
<?xml version='1.0' encoding='UTF-8'?>
<ns2:SearchEngineRegionTreeRS xmlns:ns2="http://traveltainment.de/middleware/xml/SearchEngineRegionTreeRS" CorrelationsID="fe8a5cba-f8d5-4efc-b
413-781d60aa2e4a" Success="true" ProcessingTime="166" ClientSessionID="11" TrackingID="22" LanguageCode="de-DE" Target="Test" Timestamp="2017-07-12T10:23:01">
	<Regions>
		<SubRegion>
			<ID>30000</ID>
			<RegionName>Deutschland Nord</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>112</ID>
					<RegionName>Bremen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>113</ID>
					<RegionName>Hamburg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>116</ID>
					<RegionName>Niedersachsen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2024</ID>
					<RegionName>L├╝neburger Heide</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2031</ID>
					<RegionName>Harz</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2036</ID>
					<RegionName>Nordseek├╝ste und Inseln - sonstige Angebote</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2037</ID>
					<RegionName>Emsland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2039</ID>
					<RegionName>Ostseek├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2078</ID>
					<RegionName>Borkum</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4102</ID>
					<RegionName>Schleswig-Holstein</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30001</ID>
			<RegionName>Deutschland Ost</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>106</ID>
					<RegionName>Berlin</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>107</ID>
					<RegionName>Brandenburg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>115</ID>
					<RegionName>Mecklenburg-Vorpommern</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>121</ID>
					<RegionName>Sachsen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>123</ID>
					<RegionName>Sachsen-Anhalt</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>128</ID>
					<RegionName>Th├╝ringen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2032</ID>
					<RegionName>Insel R├╝gen
					</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2033</ID>
					<RegionName>Insel Usedom</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2034</ID>
					<RegionName>Mecklenburgische Seenplatte</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2035</ID>
					<RegionName>Mecklenburg Ostseek├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2050</ID>
					<RegionName>Erzgebirge</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2067</ID>
					<RegionName>Th├╝ringer Wald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2071</ID>
					<RegionName>Lausitz</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30002</ID>
			<RegionName>Deutschland S├╝d</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>104</ID>
					<RegionName>Baden-W├╝rttemberg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>105</ID>
					<RegionName>Oberpfalz</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>264</ID>
					<RegionName>M├╝nchen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2002</ID>
					<RegionName>Schwarzwald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2008</ID>
					<RegionName>Oberbayern</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2025</ID>
					<RegionName>Bayerischer Wald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2026</ID>
					<RegionName>Allg├ñu</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2028</ID>
					<RegionName>Bodensee (Deutschland)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2058</ID>
					<RegionName>Bayerische Alpen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2060</ID>
					<RegionName>Franken</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2063</ID>
					<RegionName>Niederbayern</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2069</ID>
					<RegionName>Berchtesgadener Land</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4111</ID>
					<RegionName>Hochschwarzwald</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30003</ID>
			<RegionName>Deutschland West</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>114</ID>
					<RegionName>Hessen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>117</ID>
					<RegionName>Nordrhein-Westfalen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2019</ID>
					<RegionName>D├╝sseldorf &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2020</ID>
					<RegionName>K├Âln &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2021</ID>
					<RegionName>Teutoburger Wald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2038</ID>
					<RegionName>Sauerland
					</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2052</ID>
					<RegionName>Eifel &amp; Westerwald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2059</ID>
					<RegionName>Ruhrgebiet</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2061</ID>
					<RegionName>Hunsr├╝ck / Taunus</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2062</ID>
					<RegionName>Mosel</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2070</ID>
					<RegionName>Spessart - Odenwald</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2072</ID>
					<RegionName>Hessisches Bergland</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30004</ID>
			<RegionName>├ûsterreich</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>806</ID>
					<RegionName>Vorarlberg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>950</ID>
					<RegionName>Burgenland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>951</ID>
					<RegionName>K├ñrnten</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>952</ID>
					<RegionName>Nieder├Âsterreich</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>953</ID>
					<RegionName>Ober├Âsterreich</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>954</ID>
					<RegionName>Salzburg - Salzburg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>955</ID>
					<RegionName>Steiermark</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>956</ID>
					<RegionName>Tirol - Innsbruck, Mittel- und Nordtirol</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>958</ID>
					<RegionName>Wien &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>1003</ID>
					<RegionName>Tirol - Paznaun</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2001</ID>
					<RegionName>Tirol - Region Seefeld</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2004</ID>
					<RegionName>Tirol - Zillertal</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2005</ID>
					<RegionName>Tirol - Stubaital</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2006</ID>
					<RegionName>Salzkammergut - Ober├Âsterreich / Steiermark / Salzburg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2007</ID>
					<RegionName>Salzburg - Salzburger Land</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2009</ID>
					<RegionName>Tirol - Westtirol &amp; ├ûtztal</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2018</ID>
					<RegionName>Tirol - Osttirol</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30005</ID>
			<RegionName>Schweiz</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>915</ID>
					<RegionName>Basel &amp; Solothurn</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>916</ID>
					<RegionName>Bern &amp; Berner Oberland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>918</ID>
					<RegionName>Genf</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>920</ID>
					<RegionName>Graub├╝nden</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>925</ID>
					<RegionName>Obwalden &amp; Nidwalden</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>926</ID>
					<RegionName>St.Gallen &amp; Thurgau</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>932</ID>
					<RegionName>Uri &amp; Glarus</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>933</ID>
					<RegionName>Waadt &amp; Jura &amp; Neuenburg</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>934</ID>
					<RegionName>Wallis</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>936</ID>
					<RegionName>Z├╝rich</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30006</ID>
			<RegionName>Benelux</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>854</ID>
					<RegionName>Niederlande</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>855</ID>
					<RegionName>Belgien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>856</ID>
					<RegionName>Luxemburg</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30007</ID>
			<RegionName>Skandinavien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>490</ID>
					<RegionName>Finnland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>813</ID>
					<RegionName>Norwegen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>851</ID>
					<RegionName>Schweden</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>902</ID>
					<RegionName>D├ñnemark</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30008</ID>
			<RegionName>Italien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>75</ID>
					<RegionName>Ischia</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>76</ID>
					<RegionName>Neapel &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>77</ID>
					<RegionName>Sizilien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>78</ID>
					<RegionName>Sardinien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>79</ID>
					<RegionName>Capri</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>81</ID>
					<RegionName>Emilia Romagna</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>82</ID>
					<RegionName>Venetien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>291</ID>
					<RegionName>Basilikata</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>464</ID>
					<RegionName>Apulien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>536</ID>
					<RegionName>Kalabrien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>537</ID>
					<RegionName>Toskana</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>560</ID>
					<RegionName>Rom &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>818</ID>
					<RegionName>Ligurien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>844</ID>
					<RegionName>Trentino &amp; S├╝dtirol</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>845</ID>
					<RegionName>Aostatal &amp; Piemont &amp; Lombardei</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2012</ID>
					<RegionName>Oberitalienische Seen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2048</ID>
					<RegionName>Gardasee</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30009</ID>
			<RegionName>Frankreich</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>23</ID>
					<RegionName>Korsika</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>25</ID>
					<RegionName>Aquitanien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>495</ID>
					<RegionName>Paris &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>880</ID>
					<RegionName>Monaco</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2041</ID>
					<RegionName>Disneyland Paris</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2042</ID>
					<RegionName>Rhone Alpes</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2043</ID>
					<RegionName>Elsass &amp; Lothringen</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2055</ID>
					<RegionName>C├┤te d'Azur</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2056</ID>
					<RegionName>Provence-Alpes-C├┤te d'Azur</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2057</ID>
					<RegionName>Languedoc Roussillon</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4127</ID>
					<RegionName>Midi Pyrenees</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30010</ID>
			<RegionName>Spanien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>32</ID>
					<RegionName>Ibiza</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>35</ID>
					<RegionName>Mallorca</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>50</ID>
					<RegionName>La Gomera</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>56</ID>
					<RegionName>Teneriffa</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>61</ID>
					<RegionName>Costa de la Luz</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>62</ID>
					<RegionName>Costa del Sol &amp; Costa Tropical</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>63</ID>
					<RegionName>Golf von Almeria</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>64</ID>
					<RegionName>Costa Blanca &amp; Costa Calida</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>229</ID>
					<RegionName>Andalusien Inland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>345</ID>
					<RegionName>Gran Canaria</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>505</ID>
					<RegionName>Nordspanien - Atlantikk├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>627</ID>
					<RegionName>Formentera</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>630</ID>
					<RegionName>Menorca</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>675</ID>
					<RegionName>La Palma</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>676</ID>
					<RegionName>Lanzarote</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>794</ID>
					<RegionName>Madrid &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>832</ID>
					<RegionName>Fuerteventura</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>931</ID>
					<RegionName>Costa Barcelona</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2013</ID>
					<RegionName>Costa Brava</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2014</ID>
					<RegionName>Costa Azahar</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2054</ID>
					<RegionName>Costa Dorada</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2068</ID>
					<RegionName>Barcelona &amp; Umgebung</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30011</ID>
			<RegionName>Slowakei / Tschechien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>853</ID>
					<RegionName>Tschechien</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30012</ID>
			<RegionName>Polen</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>852</ID>
					<RegionName>Polen</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30013</ID>
			<RegionName>Ungarn</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>849</ID>
					<RegionName>Ungarn</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2016</ID>
					<RegionName>Ungarn: Plattensee / Balaton</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30014</ID>
			<RegionName>Kroatien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>301</ID>
					<RegionName>Kroatien: Mittelkroatien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>480</ID>
					<RegionName>Kroatien: Kvarner Bucht</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>483</ID>
					<RegionName>Kroatien: Istrien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>500</ID>
					<RegionName>Kroatien: Insel Hvar</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>501</ID>
					<RegionName>Kroatien: Insel Brac</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>504</ID>
					<RegionName>Kroatische Inseln</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>507</ID>
					<RegionName>Kroatien: Insel Krk</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>635</ID>
					<RegionName>Kroatien: S├╝ddalmatien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>877</ID>
					<RegionName>Kroatien: Mitteldalmatien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2011</ID>
					<RegionName>Kroatien: Norddalmatien</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30016</ID>
			<RegionName>USA / Kanada</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>430</ID>
					<RegionName>Hawaii - Insel Oahu</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>484</ID>
					<RegionName>Arizona</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>521</ID>
					<RegionName>Florida Ostk├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>522</ID>
					<RegionName>Florida Westk├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>523</ID>
					<RegionName>Florida S├╝dspitze</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>524</ID>
					<RegionName>Florida Orlando &amp; Inland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>688</ID>
					<RegionName>Kalifornien</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>692</ID>
					<RegionName>Nevada</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>697</ID>
					<RegionName>New York</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>752</ID>
					<RegionName>Utah</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>755</ID>
					<RegionName>Texas</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>756</ID>
					<RegionName>Louisiana &amp; Mississippi</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>757</ID>
					<RegionName>Georgia</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>758</ID>
					<RegionName>Pennsylvania</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>759</ID>
					<RegionName>Illinois &amp; Wisconsin</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>763</ID>
					<RegionName>Washington D.C. &amp; Maryland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>765</ID>
					<RegionName>Kanada: Quebec</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>766</ID>
					<RegionName>Kanada: Ontario</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>768</ID>
					<RegionName>Kanada: British Columbia</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>775</ID>
					<RegionName>South Carolina</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>780</ID>
					<RegionName>Virginia &amp; West Virgina</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>781</ID>
					<RegionName>Alaska</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>782</ID>
					<RegionName>New Jersey &amp; Delaware</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>886</ID>
					<RegionName>New England</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30018</ID>
			<RegionName>Australien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>795</ID>
					<RegionName>Queensland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>798</ID>
					<RegionName>Victoria</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30020</ID>
			<RegionName>Dubai, Arabische Halbinsel</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>352</ID>
					<RegionName>Sharjah / Khorfakkan</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>353</ID>
					<RegionName>Dubai</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>354</ID>
					<RegionName>Abu Dhabi</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>722</ID>
					<RegionName>Fujairah</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>723</ID>
					<RegionName>Ras Al-Khaimah</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>724</ID>
					<RegionName>Ajman</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30021</ID>
			<RegionName>T├╝rkei</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>373</ID>
					<RegionName>Istanbul &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>434</ID>
					<RegionName>Antalya &amp; Belek</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>526</ID>
					<RegionName>T├╝rkei Inland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>542</ID>
					<RegionName>Mersin - Adana - Antakya</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>643</ID>
					<RegionName>Side &amp; Alanya</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>644</ID>
					<RegionName>Kemer &amp; Beldibi</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>646</ID>
					<RegionName>Dalyan - Dalaman - Fethiye - ├ûl├╝deniz - Kas</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>647</ID>
					<RegionName>Marmaris &amp; Icmeler &amp; Datca</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>648</ID>
					<RegionName>Bodrum</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>651</ID>
					<RegionName>Kusadasi &amp; Didyma</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>652</ID>
					<RegionName>Ayvalik, Cesme &amp; Izmir</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30022</ID>
			<RegionName>Portugal</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>339</ID>
					<RegionName>Alentejo - Beja / Setubal / Evora / Santarem / Portalegre</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>457</ID>
					<RegionName>Costa de Prata (Leira / Coimbra / Aveiro)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>467</ID>
					<RegionName>Porto</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>494</ID>
					<RegionName>Costa Verde (Braga / Viana do Castelo)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>636</ID>
					<RegionName>Costa da Caparica (Set├║bal)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>637</ID>
					<RegionName>Faro &amp; Algarve</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>639</ID>
					<RegionName>Madeira</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>664</ID>
					<RegionName>Azoren</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>667</ID>
					<RegionName>Pico (Azoren)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>674</ID>
					<RegionName>Lissabon &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>695</ID>
					<RegionName>Costa do Estoril (Lissabon)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>2662</ID>
					<RegionName>Porto Santo</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30023</ID>
			<RegionName>Gro├ƒbritannien / Irland</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>178</ID>
					<RegionName>London &amp; S├╝dengland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>503</ID>
					<RegionName>Irland</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>901</ID>
					<RegionName>Schottland</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30024</ID>
			<RegionName>Malta</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>595</ID>
					<RegionName>Malta</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30025</ID>
			<RegionName>Osteuropa</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>102</ID>
					<RegionName>Bulgarien: Sonnenstrand / Burgas / Nessebar</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>103</ID>
					<RegionName>Bulgarien: Goldstrand / Varna</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>539</ID>
					<RegionName>Bulgarien (Landesinnere)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>1027</ID>
					<RegionName>Bulgarien: Albena &amp; Umgebung</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30026</ID>
			<RegionName>Zypern</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>99</ID>
					<RegionName>Nordzypern</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>620</ID>
					<RegionName>Republik Zypern - S├╝den</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30027</ID>
			<RegionName>Karibik</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>245</ID>
					<RegionName>Barbados</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>247</ID>
					<RegionName>Jamaika</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>366</ID>
					<RegionName>Dom. Republik - Norden (Puerto Plata &amp; Samana)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>367</ID>
					<RegionName>Dom. Republik - Osten (Punta Cana)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>368</ID>
					<RegionName>Dom. Republik - S├╝den (Santo Domingo)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>369</ID>
					<RegionName>Kuba - Havanna / Varadero / Mayabeque / Artemisa / P. del Rio</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>371</ID>
					<RegionName>Kuba - Holguin / S.de Cuba / Granma / Las Tunas / Guantanamo</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>377</ID>
					<RegionName>Grenada</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>378</ID>
					<RegionName>Tobago</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>582</ID>
					<RegionName>Curacao</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>3009</ID>
					<RegionName>Kuba - Santa Clara / Cienfuegos / S. Spiritus / Camag├╝ey</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>3011</ID>
					<RegionName>Kuba - Cayo Coco</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4197</ID>
					<RegionName>Aruba</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30029</ID>
			<RegionName>├ägypten</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>330</ID>
					<RegionName>Marsa Alam &amp; Quseir</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>348</ID>
					<RegionName>Kairo &amp; Gizeh &amp; Memphis &amp; Ismailia</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>349</ID>
					<RegionName>Luxor &amp; Assuan</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>350</ID>
					<RegionName>Hurghada &amp; Safaga</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>351</ID>
					<RegionName>Sharm el Sheikh / Nuweiba / Taba</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30031</ID>
			<RegionName>Island</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>449</ID>
					<RegionName>Island</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30032</ID>
			<RegionName>S├╝dafrika</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>873</ID>
					<RegionName>S├╝dafrika: Western Cape (Kapstadt)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>881</ID>
					<RegionName>S├╝dafrika: KwaZulu-Natal (Durban)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>883</ID>
					<RegionName>S├╝dafrika: Gauteng (Johannesburg)</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30033</ID>
			<RegionName>Indischer Ozean</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>143</ID>
					<RegionName>Mauritius</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>342</ID>
					<RegionName>Malediven</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>719</ID>
					<RegionName>Seychellen</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30034</ID>
			<RegionName>Kreuzfahrten</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>4010</ID>
					<RegionName>Kreuzfahrten Kroatien</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30035</ID>
			<RegionName>Afrika</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>125</ID>
					<RegionName>Marokko - Atlantikk├╝ste: Agadir / Safi / Tiznit</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>126</ID>
					<RegionName>Marokko - Marrakesch</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>131</ID>
					<RegionName>Tunesien - Norden</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>132</ID>
					<RegionName>Tunesien - Hammamet</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>133</ID>
					<RegionName>Tunesien - Insel Djerba</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>135</ID>
					<RegionName>Tunesien - Oase Zarzis</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>280</ID>
					<RegionName>Kap Verde - Boavista</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>482</ID>
					<RegionName>Marokko - Tanger &amp; Mittelmeerk├╝ste</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>585</ID>
					<RegionName>Kap Verde - Sal</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>586</ID>
					<RegionName>Kap Verde - Santiago</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>587</ID>
					<RegionName>Kap Verde - Sao Vicente &amp; Santa Luzia</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>588</ID>
					<RegionName>Kap Verde - Santo Antao</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>589</ID>
					<RegionName>Kap Verde - Fogo &amp; Brava</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>614</ID>
					<RegionName>Tunesien - Monastir</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4200</ID>
					<RegionName>Marokko - Atlantikk├╝ste: Casablanca / El Jadida / Rabat</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30037</ID>
			<RegionName>Asien</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>311</ID>
					<RegionName>Indonesien: Bali</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>321</ID>
					<RegionName>Thailand: Bangkok &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>322</ID>
					<RegionName>Thailand: Insel Phuket</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>323</ID>
					<RegionName>Thailand: Inseln im Golf (Koh Chang, Koh Phangan)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>325</ID>
					<RegionName>Thailand: Insel Ko Samui</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>327</ID>
					<RegionName>Thailand: Inseln Andaman See (Koh Pee Pee, Koh Lanta)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>439</ID>
					<RegionName>China - Peking (Beijing)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>846</ID>
					<RegionName>Thailand: Khao Lak &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4128</ID>
					<RegionName>Thailand: Norden (Chiang Mai, Chiang Rai, Sukhothai)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4130</ID>
					<RegionName>Thailand: Westen (Hua Hin, Cha Am, River Kwai)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4131</ID>
					<RegionName>Thailand: S├╝dosten (Pattaya, Jomtien)</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>4133</ID>
					<RegionName>Thailand: Krabi &amp;Umgebung</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30038</ID>
			<RegionName>Griechenland</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>6</ID>
					<RegionName>Korfu &amp; Paxi</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>7</ID>
					<RegionName>Kos</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>8</ID>
					<RegionName>Lesbos &amp; Lemnos &amp; Samothraki</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>9</ID>
					<RegionName>Mykonos</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>12</ID>
					<RegionName>Santorin</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>13</ID>
					<RegionName>Skiathos, Skopelos &amp; Skyros</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>14</ID>
					<RegionName>Zakynthos</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>16</ID>
					<RegionName>Thassos</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>18</ID>
					<RegionName>Athen &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>382</ID>
					<RegionName>Peloponnes</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>396</ID>
					<RegionName>Kefalonia &amp; Ithaki</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>534</ID>
					<RegionName>Chalkidiki</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>616</ID>
					<RegionName>Kreta</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>625</ID>
					<RegionName>Thessaloniki</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>655</ID>
					<RegionName>Rhodos</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>733</ID>
					<RegionName>Olympische Riviera</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30039</ID>
			<RegionName>Mittelamerika</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>282</ID>
					<RegionName>Mexiko: Yucatan / Cancun</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
		<SubRegion>
			<ID>30045</ID>
			<RegionName>Naher Osten</RegionName>
			<SubRegions>
				<SubRegion>
					<ID>225</ID>
					<RegionName>Israel - Eilat</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>509</ID>
					<RegionName>Israel - Jerusalem &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>510</ID>
					<RegionName>Israel - Tel Aviv &amp; Umgebung</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>511</ID>
					<RegionName>Israel</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>532</ID>
					<RegionName>Oman</RegionName>
				</SubRegion>
				<SubRegion>
					<ID>727</ID>
					<RegionName>Israel - Totes Meer</RegionName>
				</SubRegion>
			</SubRegions>
		</SubRegion>
	</Regions>
</ns2:SearchEngineRegionTreeRS>
TAG;

        $this->assertEquals($expectedOutput, $receivedOutput);

    }
}