<?php

namespace Vtours\TTXmlWebService\Model\Request\V2\PackageOffersRQ;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\V2\OfferTravellers;
use Vtours\TTXmlWebService\Model\Request\V2\OfferFilters;
use Vtours\TTXmlWebService\Model\Request\V2\RQMeta;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class PackageOffersRQ
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\V2\RQMeta")
     * @Serializer\SerializedName("RQ_Metadata")
     *
     * @var RQMeta
     *
     */
    private $RQMeta;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CurrencyCode")
     *
     * @var string
     */
    private $currencyCode = "EUR";


    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\V2\OfferTravellers")
     * @Serializer\SerializedName("Travellers")
     *
     * @var OfferTravellers
     *
     */
    private $travellers;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\V2\OfferFilters")
     * @Serializer\SerializedName("OfferFilters")
     *
     * @var OfferFilters
     *
     */
    private $offerFilters;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\V2\OfferOptions")
     * @Serializer\SerializedName("Options")
     *
     * @var OfferOptions
     */
    private $offerOptions;

    /**
     * @return RQMeta
     */
    public function getRQMeta()
    {
        return $this->RQMeta;
    }

    /**
     * @param RQMeta $RQMeta
     */
    public function setRQMeta($RQMeta)
    {
        $this->RQMeta = $RQMeta;
    }

    /**
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param string $currencyCode
     */
    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Request\V2\PackageOfferTravellers
     */
    public function getTravellers()
    {
        return $this->travellers;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Request\V2\PackageOfferTravellers $travellers
     */
    public function setTravellers($travellers)
    {
        $this->travellers = $travellers;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Request\V2\OfferFilters
     */
    public function getOfferFilters()
    {
        return $this->offerFilters;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Request\V2\OfferFilters $offerFilters
     */
    public function setOfferFilters($offerFilters)
    {
        $this->offerFilters = $offerFilters;
    }

    /**
     * @return OfferOptions
     */
    public function getOfferOptions()
    {
        return $this->offerOptions;
    }

    /**
     * @param OfferOptions $offerOptions
     */
    public function setOfferOptions($offerOptions)
    {
        $this->offerOptions = $offerOptions;
    }

    /**
     * @return PackageOffersRQ
     */
    public function getPackageOffersRQ()
    {
        return $this->packageOffersRQ;
    }

    /**
     * @param PackageOffersRQ $packageOffersRQ
     */
    public function setPackageOffersRQ($packageOffersRQ)
    {
        $this->packageOffersRQ = $packageOffersRQ;
    }


}
