<?php

namespace Vtours\TTXmlWebService\Model\Response\V2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\V2\Offers\InBoundFlight;
use Vtours\TTXmlWebService\Model\Response\V2\Offers\OutboundFlight;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Flight
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\V2\Offers\OutboundFlight")
     * @Serializer\SerializedName("OutboundFlight")
     *
     * @var OutboundFlight
     */
    private $outboundFlight;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\V2\Offers\InBoundFlight")
     * @Serializer\SerializedName("InBoundFlight")
     *
     * @var InBoundFlight
     */
    private $inboundFlight;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\V2\Offers\OutboundFlight
     */
    public function getOutboundFlight()
    {
        return $this->outboundFlight;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\V2\Offers\OutboundFlight $outboundFlight
     */
    public function setOutboundFlight($outboundFlight)
    {
        $this->outboundFlight = $outboundFlight;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\V2\Offers\InBoundFlight
     */
    public function getInboundFlight()
    {
        return $this->inboundFlight;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\V2\Offers\InBoundFlight $inboundFlight
     */
    public function setInboundFlight($inboundFlight)
    {
        $this->inboundFlight = $inboundFlight;
    }

    
}
