<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\PriceResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class PriceInformation
 *
 * @package Vtours\TTXmlWebService\Model\Response\PriceResponse
 */
class PriceInformation
{
    /**
     * @var OriginalPrice
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\PriceResponse\OriginalPrice")
     * @Serializer\SerializedName("OriginalPrice")
     */
    private $originalPrice;

    /**
     * @var ConvertedPrice
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\PriceResponse\ConvertedPrice")
     * @Serializer\SerializedName("ConvertedPrice")
     */
    private $convertedPrice;

    /**
     * @return OriginalPrice
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }

    /**
     * @param OriginalPrice $originalPrice
     *
     * @return PriceInformation
     */
    public function setOriginalPrice($originalPrice)
    {
        $this->originalPrice = $originalPrice;

        return $this;
    }

    /**
     * @return ConvertedPrice
     */
    public function getConvertedPrice()
    {
        return $this->convertedPrice;
    }

    /**
     * @param ConvertedPrice $convertedPrice
     *
     * @return PriceInformation
     */
    public function setConvertedPrice($convertedPrice)
    {
        $this->convertedPrice = $convertedPrice;

        return $this;
    }
}
