<?php

namespace Vtours\TTXmlWebService\Model\Response\V2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class HotelCodes
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelIffCode")
     *
     * @var integer
     */
    private $hotelIffCode;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelGiataID")
     *
     * @var integer
     */
    private $hotelGiataId;

    /**
     * @return int
     */
    public function getHotelIffCode()
    {
        return $this->hotelIffCode;
    }

    /**
     * @param int $hotelIffCode
     */
    public function setHotelIffCode($hotelIffCode)
    {
        $this->hotelIffCode = $hotelIffCode;
    }

    /**
     * @return int
     */
    public function getHotelGiataId()
    {
        return $this->hotelGiataId;
    }

    /**
     * @param int $hotelGiataId
     */
    public function setHotelGiataId($hotelGiataId)
    {
        $this->hotelGiataId = $hotelGiataId;
    }

}
