<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Vtours\TTXmlWebService\Service;

use Vtours\TTXmlWebService\Service\HotelList\Handler as HotelListHandler;
use Vtours\TTXmlWebService\Service\OfferList\Handler as OfferListHandler;
use Vtours\TTXmlWebService\Service\RegionTree\Handler as RegionTreeHandler;

/**
 * Class Factory
 *
 * @package Vtours\TTXmlWebService\Service
 */
class Factory
{
    /**
     * @var HotelListHandler
     */
    private $hotelListHandler;
    /**
     * @var OfferListHandler
     */
    private $offerListHandler;
    /**
     * @var RegionTreeHandler
     */
    private $regionTreeHandler;

    /**
     * Factory constructor.
     *
     * @param HotelListHandler  $hotelListHandler
     * @param OfferListHandler  $offerListHandler
     * @param RegionTreeHandler $regionTreeHandler
     *
     */
    public function __construct(HotelListHandler $hotelListHandler, OfferListHandler $offerListHandler, RegionTreeHandler $regionTreeHandler)
    {
        $this->hotelListHandler = $hotelListHandler;
        $this->offerListHandler = $offerListHandler;
        $this->regionTreeHandler = $regionTreeHandler;
    }

    /**
     * @return HotelListHandler
     */
    public function hotelList()
    {
        return $this->hotelListHandler;
    }

    /**
     * @return OfferListHandler
     */
    public function offerList()
    {
        return $this->offerListHandler;
    }

    public function regionTree()
    {
        return $this->regionTreeHandler;
    }
}
