<?php

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class InventoryDataForPackageRQ
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\RQMeta")
     * @Serializer\SerializedName("RQ_Metadata")
     *
     * @var RQMeta
     *
     */
    private $RQMeta;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("array")
     * @Serializer\SerializedName("EntityKinds")
     *
     * @var array
     *
     */
    private $entityKinds = ['TouristicRegions'];

    /**
     * @return RQMeta
     */
    public function getRQMeta()
    {
        return $this->RQMeta;
    }

    /**
     * @param RQMeta $RQMeta
     */
    public function setRQMeta($RQMeta)
    {
        $this->RQMeta = $RQMeta;
    }

    /**
     * @return array
     */
    public function getEntityKinds()
    {
        return $this->entityKinds;
    }

    /**
     * @param array $entityKinds
     */
    public function setEntityKinds($entityKinds)
    {
        $this->entityKinds = $entityKinds;
    }
}
