<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Cities
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Cities
{

    /**
     * @var array<RegionCity>
     * @Serializer\XmlList(inline = true, entry = "Region")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\RegionCity>")
     * @Serializer\SerializedName("Region")
     */
    private $region;

    /**
     * @return array
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param array $region
     *
     * @return Cities
     */
    public function setRegion($region)
    {
        $this->region = $region;

        return $this;
    }
}
