<?php
namespace Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\ClimateParameterValue;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class ClimateParameter
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\ClimateParameterValue>")
     * @Serializer\SerializedName("ClimateParameterValue")
     *
     * @var ClimateParameterValue
     */
    private $climateParameterValue;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ClimateParameterType")
     *
     * @var string
     */
    private $climateParameterType;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\ClimateParameterValue
     */
    public function getClimateParameterValue()
    {
        return $this->climateParameterValue;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\V2\ClimateParameterValue $climateParameterValue
     */
    public function setClimateParameterValue($climateParameterValue)
    {
        $this->climateParameterValue = $climateParameterValue;
    }

    /**
     * @return string
     */
    public function getClimateParameterType()
    {
        return $this->climateParameterType;
    }

    /**
     * @param string $climateParameterType
     */
    public function setClimateParameterType($climateParameterType)
    {
        $this->climateParameterType = $climateParameterType;
    }
}
