<?php

namespace Vtours\TTXmlWebService\Model\Response\V2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class HotelImages
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Thumbnail")
     *
     * @var string
     */
    private $thumbNails;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("MediumImage")
     *
     * @var string
     */
    private $mediumImage;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LargeImage")
     *
     * @var string
     */
    private $largeImage;

    /**
     * @return string
     */
    public function getThumbNails()
    {
        return $this->thumbNails;
    }

    /**
     * @param string $thumbNails
     */
    public function setThumbNails($thumbNails)
    {
        $this->thumbNails = $thumbNails;
    }

    /**
     * @return string
     */
    public function getMediumImage()
    {
        return $this->mediumImage;
    }

    /**
     * @param string $mediumImage
     */
    public function setMediumImage($mediumImage)
    {
        $this->mediumImage = $mediumImage;
    }

    /**
     * @return string
     */
    public function getLargeImage()
    {
        return $this->largeImage;
    }

    /**
     * @param string $largeImage
     */
    public function setLargeImage($largeImage)
    {
        $this->largeImage = $largeImage;
    }

}
