<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Service\RegionTree;

use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * Class Handler
 *
 * @package Vtours\TTXmlWebService\Service\RegionTree
 */
class Handler
{
    const API_URI = '/TTXml-1.7/Dispatcher/Search/Hotel/RegionTree';

    /**
     * @var Mapper
     */
    private $mapper;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ClientInterface
     */
    private $client;

    /**
     * Handler constructor.
     *
     * @param Mapper              $mapper
     * @param SerializerInterface $serializer
     * @param ClientInterface     $client
     */
    public function __construct(Mapper $mapper, SerializerInterface $serializer, ClientInterface $client)
    {
        $this->mapper = $mapper;
        $this->serializer = $serializer;
        $this->client = $client;
    }

    /**
     * @return array|\Exception|\JMS\Serializer\scalar|object
     */
    public function getRegionTree()
    {
        $requestModel = $this->mapper->mapRequestForRegionTree();
        $requestXml = $this->serializer->serialize($requestModel, 'xml');

        $requestOptions = [
            'headers' => [],
            'auth'    => ['MKT_655000_DE', '193893Hjtt0!aaaqq', 'digest'],
            'body'    => $requestXml,
        ];

        try {
            /** @var ResponseInterface $response */
            $response = $this->client->request('POST', self::API_URI, $requestOptions);
            $result = $response->getBody()->getContents();

            return $this->serializer->deserialize($result, \Vtours\TTXmlWebService\Model\Response\SearchEngineRegionTreeRS::class, 'xml');
        } catch (\Exception $exception) {
            // return false or null? or maybe do not catch exception in pimcore context?
            return $exception;
        }
    }
}
