<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Serializer;
use Vtours\TTXmlWebService\Service\TravelTainmentService;


class TravelTainmentServiceTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    public function testOfferByHotel()
    {
        $this->markTestSkipped('skip single offer by hotel code');
        $ttService = new TravelTainmentService();

        $hotelId = 32394; //giata
        $hotelCodeType = 'Giata';
        $mealType = null;
        $durationDays = [2, 5];
        $departureDate = date('Y-m-d H:i', time());
        $returnDate = date('Y-m-d H:i', time() + (21 * 24 * 60 * 60));
        $durationPeriod = [$departureDate, $returnDate];
        $type = 'Hotel'; //change to 'Package' for offers with flight

        $travellers = [
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(30),
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(14),
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(2)
        ];

        $specialJourneyAttributes = ['TRANSFER'];

        $pricing = [1500, 3000];

        $brand = 'VTO';

        $hotelAttributes = [
            'SANDYBEACH'
        ];

        $departureAirport = 'FRA';


        $request = new \Vtours\TTXmlWebService\Model\Request\SearchEngineOfferListRQ($durationDays, $durationPeriod, $pricing, $hotelAttributes,
            $mealType,
            $travellers, $specialJourneyAttributes, $brand, $departureAirport, $hotelId, $hotelCodeType);
        $requestxml = $this->serializer->serialize($request, 'xml');
        echo($requestxml);

        /**
         * @var $response \GuzzleHttp\Psr7\Response
         */
        $response = $ttService->getAllHotelOffersByHotelCode($durationDays, $durationPeriod, $pricing, $hotelAttributes, $mealType, $travellers,
            $specialJourneyAttributes,
            $brand, $departureAirport, $hotelId, $hotelCodeType, $type);

        //$result = $this->serializer->deserialize($response, Vtours\TTXmlWebService\Model\Response\SearchEngineOfferListRS::class, 'xml');

        //echo($result);
        //echo($response);

    }


    public
    function testGetBestOfferOfCity()
    {
        $this->markTestSkipped('skip offer city -> request unused');

        $ttService = new TravelTainmentService();

        $cityId = [1732];
        $topRegionIds = [35];
        $mealType = 'BREAKFAST';
        $durationDays = [2, 5];

        $response = $ttService->getBestCityOffer($durationDays, $mealType, $cityId, $topRegionIds);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS::class, 'xml');

//        /**
//         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
//         */
//        $listitem = $result->getResultSet()->getListItem();
//        foreach ($listitem as $item) {
//            var_dump($result);
//            var_dump($item);
//            var_dump($item->getRegion()->getWeatherForRegion()->getClimaData());
//            $offer = $item->getOffer();
//            var_dump($offer);
//            }

//        var_dump($result);
    }

    public function testGetBestOfferByHotel()
    {
        $this->markTestSkipped('skip single offer by hotel -> request unused');

        $ttService = new TravelTainmentService();
        $hotelId = 32394; //giata
//        $regionId = 106; // Berlin
        $duration = [4, 8];
        $mealType = 'BREAKFAST';

        $req = new \Vtours\TTXmlWebService\Model\Request\SearchEngineHotelListRQ($duration, $mealType, $hotelId, null);
        $xml = $this->serializer->serialize($req, 'xml');

        echo $xml;

        $response = $ttService->getBestPackageOfferByGiata($hotelId, $duration, $mealType);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS::class, 'xml');

        /**
         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
         */
        $listitem = $result->getResultSet()->getListItem();
        foreach ($listitem as $item) {
//            var_dump($item);
//            $offer = $item->getOffer();
//            var_dump($offer);
        }
//        echo $obj;
//        var_dump($result);
    }

    public function testGetBestHotelOffersByRegion()
    {
        $this->markTestSkipped('skip offer by city');

        $type = 'Hotel'; //change to 'Package' for offers with flight

        $travellers = [
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(30),
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(14),
            new \Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Traveller(2)
        ];

        $specialJourneyAttributes = ['TRANSFER'];

        $pricing = [1500, 3000];

        $brand = 'VTO';

        $hotelAttributes = [
            'SANDYBEACH'
        ];

        $departureAirport = 'FRA';

        $ttService = new TravelTainmentService();
        $regionId = 106; // Berlin
        $duration = [4, 8];
        $departureDate = date('Y-m-d H:i', time());
        $returnDate = date('Y-m-d H:i', time() + (21 * 24 * 60 * 60));
        $durationPeriod = [$departureDate, $returnDate];
        $mealType = 'BREAKFAST';

        $response = $ttService->getBestHotelOffersByRegion($duration, $durationPeriod, $pricing, $hotelAttributes, $mealType, $travellers,
            $specialJourneyAttributes, $brand, $departureAirport, $regionId, $type);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS::class, 'xml');

        /**
         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
         */
        $listitem = $result->getResultSet()->getListItem();
//        foreach ($listitem as $item) {
//            var_dump($item);
//            $offer = $item->getOffer();
//            var_dump($offer);
//        }
//        echo $obj;
//        var_dump($result);
    }

}