<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\WeatherResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class WeatherForRegion
 *
 * @package Vtours\TTXmlWebService\Model\Response\WeatherResponse
 */
class WeatherForRegion
{
    /**
     * @var ClimaData
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\WeatherResponse\ClimaData")
     * @Serializer\SerializedName("ClimaData")
     */
    private $climaData;

    /**
     * @return ClimaData
     */
    public function getClimaData()
    {
        return $this->climaData;
    }

    /**
     * @param ClimaData $climaData
     *
     * @return WeatherForRegion
     */
    public function setClimaData($climaData)
    {
        $this->climaData = $climaData;

        return $this;
    }
}
