<?php

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\DateAndTimeFilter;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\AccomFilter;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\PriceFilter;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\StationFilter;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\TravelDurationFilter;

/**
 * @Serializer\ExclusionPolicy("all")
 *
 */
class OfferFilters
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\DateAndTimeFilter")
     * @Serializer\SerializedName("DateAndTimeFilter")
     *
     * @var DateAndTimeFilter
     */
    private $dateAndTimeFilter;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\StationFilter")
     * @Serializer\SerializedName("StationFilter")
     *
     * @var StationFilter
     */
    private $stationFilter;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\TravelDurationFilter")
     * @Serializer\SerializedName("TravelDurationFilter")
     *
     * @var TravelDurationFilter
     */
    private $travelDurationFilter;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\PriceFilter")
     * @Serializer\SerializedName("PriceFilter")
     *
     * @var PriceFilter
     */
    private $priceFilter;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\AccomFilter")
     * @Serializer\SerializedName("AccomFilter")
     *
     * @var AccomFilter
     */
    private $accomFilter;

    /**
     * @return TravelDurationFilter
     */
    public function getTravelDurationFilter()
    {
        return $this->travelDurationFilter;
    }

    /**
     * @param TravelDurationFilter $travelDurationFilter
     */
    public function setTravelDurationFilter($travelDurationFilter)
    {
        $this->travelDurationFilter = $travelDurationFilter;
    }

    /**
     * @return PriceFilter
     */
    public function getPriceFilter()
    {
        return $this->priceFilter;
    }

    /**
     * @param PriceFilter $priceFilter
     */
    public function setPriceFilter($priceFilter)
    {
        $this->priceFilter = $priceFilter;
    }

    /**
     * @return AccomFilter
     */
    public function getAccomFilter()
    {
        return $this->accomFilter;
    }

    /**
     * @param AccomFilter $accomFilter
     */
    public function setAccomFilter($accomFilter)
    {
        $this->accomFilter = $accomFilter;
    }

    /**
     * @return StationFilter
     */
    public function getStationFilter()
    {
        return $this->stationFilter;
    }

    /**
     * @param StationFilter $stationFilter
     */
    public function setStationFilter($stationFilter)
    {
        $this->stationFilter = $stationFilter;
    }

    /**
     * @return DateAndTimeFilter
     */
    public function getDateAndTimeFilter()
    {
        return $this->dateAndTimeFilter;
    }

    /**
     * @param DateAndTimeFilter $dateAndTimeFilter
     */
    public function setDateAndTimeFilter($dateAndTimeFilter)
    {
        $this->dateAndTimeFilter = $dateAndTimeFilter;
    }
}
