<?php
namespace Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Region;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Regions
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Region>")
     * @Serializer\SerializedName("Region")
     *
     * @var Region
     */
    private $region;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Region
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Region $region
     */
    public function setRegion($region)
    {
        $this->region = $region;
    }
}
