<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SearchEngineOfferListRS
 *
 * @package Vtours\TTXmlWebService\Model\Response
 *
 * @Serializer\XmlRoot("SearchEngineOfferListRS")
 * @Serializer\XmlNamespace(uri="http://traveltainment.de/middleware/xml/SearchEngineOfferListRS", prefix ="t")
 */
class SearchEngineOfferListRS
{

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ClientSessionId")
     */
    private $clientSessionID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CorrelationsID")
     */
    private $correlationsID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     */
    private $languageCode;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ProcessingTime")
     */
    private $processingTime;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("SessionID")
     */
    private $sessionID;

    /**
     * @var bool
     * @Serializer\XmlAttribute()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("Success")
     */
    private $success;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Target")
     */
    private $target;

    /**
     * @var \DateTime
     * @Serializer\XmlAttribute()
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:s'>")
     * @Serializer\SerializedName("Timestamp")
     */
    private $timestamp;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("TrackingID")
     */
    private $trackingID;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("CID")
     */
    private $cid;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("InfoMessage")
     */
    private $infoMessage;

    /**
     * @var ResultSet
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\ResultSet")
     * @Serializer\SerializedName("ResultSet")
     */
    private $resultSet;

    /**
     * @var Header
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Header")
     * @Serializer\SerializedName("Header")
     */
    private $header;

    /**
     * @var Hotel|null
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Hotel")
     * @Serializer\SerializedName("Hotel")
     */
    private $hotel;

    /**
     * @var Region
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Region")
     * @Serializer\SerializedName("Region")
     */
    private $region;

    /**
     * @return Hotel
     */
    public function getHotel()
    {
        return $this->hotel;
    }

    /**
     * @param Hotel $hotel
     *
     * @return SearchEngineOfferListRS
     */
    public function setHotel($hotel)
    {
        $this->hotel = $hotel;

        return $this;
    }

    /**
     * SearchEngineOfferListRS constructor.
     *
     * @param int       $clientSessionID
     * @param int       $correlationsID
     * @param string    $languageCode
     * @param int       $processingTime
     * @param int       $sessionID
     * @param bool      $success
     * @param string    $target
     * @param \DateTime $timestamp
     * @param int       $trackingID
     * @param int       $cid
     * @param string    $infoMessage
     * @param ResultSet $resultSet
     * @param Header    $header
     * @param Region    $region
     */
    public function __construct(
        $clientSessionID,
        $correlationsID,
        $languageCode,
        $processingTime,
        $sessionID,
        $success,
        $target,
        \DateTime $timestamp,
        $trackingID,
        $cid,
        $infoMessage,
        ResultSet $resultSet,
        Header $header,
        Region $region
    ) {
        $this->clientSessionID = $clientSessionID;
        $this->correlationsID = $correlationsID;
        $this->languageCode = $languageCode;
        $this->processingTime = $processingTime;
        $this->sessionID = $sessionID;
        $this->success = $success;
        $this->target = $target;
        $this->timestamp = $timestamp;
        $this->trackingID = $trackingID;
        $this->cid = $cid;
        $this->infoMessage = $infoMessage;
        $this->resultSet = $resultSet;
        $this->header = $header;
        $this->region = $region;
    }

    /**
     * @return int
     */
    public function getClientSessionID()
    {
        return $this->clientSessionID;
    }

    /**
     * @param int $clientSessionID
     *
     * @return SearchEngineOfferListRS
     */
    public function setClientSessionID($clientSessionID)
    {
        $this->clientSessionID = $clientSessionID;

        return $this;
    }

    /**
     * @return int
     */
    public function getCorrelationsID()
    {
        return $this->correlationsID;
    }

    /**
     * @param int $correlationsID
     *
     * @return SearchEngineOfferListRS
     */
    public function setCorrelationsID($correlationsID)
    {
        $this->correlationsID = $correlationsID;

        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     *
     * @return SearchEngineOfferListRS
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }

    /**
     * @return int
     */
    public function getProcessingTime()
    {
        return $this->processingTime;
    }

    /**
     * @param int $processingTime
     *
     * @return SearchEngineOfferListRS
     */
    public function setProcessingTime($processingTime)
    {
        $this->processingTime = $processingTime;

        return $this;
    }

    /**
     * @return int
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }

    /**
     * @param int $sessionID
     *
     * @return SearchEngineOfferListRS
     */
    public function setSessionID($sessionID)
    {
        $this->sessionID = $sessionID;

        return $this;
    }

    /**
     * @return bool
     */
    public function isSuccess()
    {
        return $this->success;
    }

    /**
     * @param bool $success
     *
     * @return SearchEngineOfferListRS
     */
    public function setSuccess($success)
    {
        $this->success = $success;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param string $target
     *
     * @return SearchEngineOfferListRS
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * @param \DateTime $timestamp
     *
     * @return SearchEngineOfferListRS
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * @return int
     */
    public function getTrackingID()
    {
        return $this->trackingID;
    }

    /**
     * @param int $trackingID
     *
     * @return SearchEngineOfferListRS
     */
    public function setTrackingID($trackingID)
    {
        $this->trackingID = $trackingID;

        return $this;
    }

    /**
     * @return int
     */
    public function getCid()
    {
        return $this->cid;
    }

    /**
     * @param int $cid
     *
     * @return SearchEngineOfferListRS
     */
    public function setCid($cid)
    {
        $this->cid = $cid;

        return $this;
    }

    /**
     * @return string
     */
    public function getInfoMessage()
    {
        return $this->infoMessage;
    }

    /**
     * @param string $infoMessage
     *
     * @return SearchEngineOfferListRS
     */
    public function setInfoMessage($infoMessage)
    {
        $this->infoMessage = $infoMessage;

        return $this;
    }

    /**
     * @return ResultSet
     */
    public function getResultSet()
    {
        return $this->resultSet;
    }

    /**
     * @param ResultSet $resultSet
     *
     * @return SearchEngineOfferListRS
     */
    public function setResultSet($resultSet)
    {
        $this->resultSet = $resultSet;

        return $this;
    }

    /**
     * @return Header
     */
    public function getHeader()
    {
        return $this->header;
    }

    /**
     * @param Header $header
     *
     * @return SearchEngineOfferListRS
     */
    public function setHeader($header)
    {
        $this->header = $header;

        return $this;
    }

    /**
     * @return Region
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param Region $region
     *
     * @return SearchEngineOfferListRS
     */
    public function setRegion($region)
    {
        $this->region = $region;

        return $this;
    }
}
