<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Serializer;

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 04.07.2017
 * Time: 13:41
 */
class RegionTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    /**
     * @Ig
     */
    public function testRegion()
    {
        $this->markTestSkipped('skip region');

        $region = new \Vtours\TTXmlWebService\Model\Response\Region('DE',
            'testregion',
            123,
            111111,
            222,
            'ABC');
        $input = <<<'TAG'
<?xml version="1.0" encoding="UTF-8"?>
<Region>
  <country><![CDATA[DE]]></country>
  <region><![CDATA[testregion]]></region>
  <regionRefID>123</regionRefID>
  <destinationID>111111</destinationID>
  <topRegionID>222</topRegionID>
  <destinationAirport><![CDATA[ABC]]></destinationAirport>
</Region>

TAG;


        $input = $this->serializer->deserialize($input, 'Vtours\TTXmlWebService\Model\Response\Region', 'xml');
        $this->assertEquals($input, $region);
    }
}