<?php
namespace Vtours\TTXmlWebService\Model\Response\V2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\V2\Offers\Price;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class PriceInfo
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\V2\Offers\Price")
     * @Serializer\SerializedName("Price")
     *
     * @var Price
     */
    private $price;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\V2\Offers\Price
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\V2\Offers\Price $price
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }
}
