<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Service\RegionTree;

use Ramsey\Uuid\Uuid;
use Vtours\TTXmlWebService\Model\Request\SearchEngineRegionTreeRQ;
use Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageRQ;
use Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageMainRQ;
use Vtours\TTXmlWebService\Model\Request\v2\RQMeta;

/**
 * Class Mapper
 *
 * @package Vtours\TTXmlWebService\Service\RegionTree
 */
class Mapper
{
    /**
     * @return SearchEngineRegionTreeRQ
     */
    public function mapRequestForRegionTree()
    {
        return new SearchEngineRegionTreeRQ();
    }

    public function mapRequestForRegionTreeV2()
    {
        $entityKinds = ['TouristicRegions'];

        $inventoryDataForPackageMainRQ = new InventoryDataForPackageMainRQ();
        $inventoryDataForPackageRQ = new InventoryDataForPackageRQ();

        $packageOfferMeta = new RQMeta();
        $packageOfferMeta->setRequestId(UUID::uuid4());
        $packageOfferMeta->setTransactonId(UUID::uuid4());
        $inventoryDataForPackageRQ->setRQMeta($packageOfferMeta);

        $inventoryDataForPackageRQ->setEntityKinds($entityKinds);

        $inventoryDataForPackageMainRQ->setInventoryDataForPackageRQ($inventoryDataForPackageRQ);

        return $inventoryDataForPackageMainRQ;
    }
}
