<?php

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class OfferOptions
{

    /**
     * @Serializer\Expose()
     * @Serializer\SerializedName("NumberOfResults")
     *
     * @var integer
     */
    private $numberOfResults = 1;

    /**
     * @Serializer\Expose()
     * @Serializer\SerializedName("ResultOffset")
     *
     * @var integer
     */
    private $resultOffset = 0;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("array")
     * @Serializer\SerializedName("Sorting")
     *
     * @var array
     */
    private $sorting = ['PriceAsc'];

    /**
     * @Serializer\Expose()
     * @Serializer\Type("array")
     * @Serializer\SerializedName("AdditionalCurrencyCodes")
     *
     * @var array
     */
    private $additionalCurrencyCodes = ['EUR'];

    /**
     * @return int
     */
    public function getNumberOfResults()
    {
        return $this->numberOfResults;
    }

    /**
     * @param int $numberOfResults
     */
    public function setNumberOfResults($numberOfResults)
    {
        $this->numberOfResults = $numberOfResults;
    }

    /**
     * @return int
     */
    public function getResultOffset()
    {
        return $this->resultOffset;
    }

    /**
     * @param int $resultOffset
     */
    public function setResultOffset($resultOffset)
    {
        $this->resultOffset = $resultOffset;
    }

    /**
     * @return array
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * @param array $sorting
     */
    public function setSorting($sorting)
    {
        $this->sorting = $sorting;
    }

    /**
     * @return array
     */
    public function getAdditionalCurrencyCodes()
    {
        return $this->additionalCurrencyCodes;
    }

    /**
     * @param array $additionalCurrencyCodes
     */
    public function setAdditionalCurrencyCodes($additionalCurrencyCodes)
    {
        $this->additionalCurrencyCodes = $additionalCurrencyCodes;
    }

}
