<?php

namespace Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary;


use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;
use Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Country;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Countries
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Country>")
     * @Serializer\SerializedName("Country")
     *
     * @var array|Country[]
     */
    private $country;

    /**
     * @return array|Country[]
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param array|Country[] $country
     */
    public function setCountry($country)
    {
        $this->country = $country;
    }
}
