<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Service\RegionTree;

use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerInterface;
use Psr\Http\Message\ResponseInterface;
use Vtours\TTXmlWebService\Model\Response\SearchEngineRegionTreeRS;
use Vtours\TTXmlWebService\Model\Response\V2\InventoryDataForPackageRS;

/**
 * Class Handler
 *
 * @package Vtours\TTXmlWebService\Service\RegionTree
 */
class Handler
{
    const API_URI = '/TTXml-1.7/Dispatcher/Search/Hotel/RegionTree';

    const API_URL_AUTH = 'https://auth.ws.traveltainment.eu/auth/realms/SystemUser-BasicAccessLevel/protocol/openid-connect/token';

    const API_URL_PACKAGE = 'https://marketing-de-ibe.ws.traveltainment.eu/ttgateway-web-v3/rest/PackageSearch/inventoryDataForPackage';


    /**
     * @var Mapper
     */
    private $mapper;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ClientInterface
     */
    private $client;

    /**
     * Handler constructor.
     *
     * @param Mapper              $mapper
     * @param SerializerInterface $serializer
     * @param ClientInterface     $client
     */
    public function __construct(Mapper $mapper, SerializerInterface $serializer, ClientInterface $client)
    {
        $this->mapper = $mapper;
        $this->serializer = $serializer;
        $this->client = $client;
    }

    /**
     * @return array|\Exception|\JMS\Serializer\scalar|object
     */
    public function getRegionTree()
    {
        $requestModel = $this->mapper->mapRequestForRegionTree();
        $requestXml = $this->serializer->serialize($requestModel, 'xml');

        $requestOptions = [
            'headers' => [],
            'auth'    => ['MKT_655000_DE', '193893Hjtt0!aaaqq', 'digest'],
            'body'    => $requestXml,
        ];

        try {
            /** @var ResponseInterface $response */
            $response = $this->client->request('POST', self::API_URI, $requestOptions);
            $result = $response->getBody()->getContents();

            return $this->serializer->deserialize($result, SearchEngineRegionTreeRS::class, 'xml');
        } catch (\Exception $exception) {
            // return false or null? or maybe do not catch exception in pimcore context?
            return $exception;
        }
    }

    ### V2
    /**
     * @return mixed|string
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    private function oauth2AccessToken()
    {
        $requestOptions = [
            'headers' => [],
            'form_params' => [
                'grant_type' => 'password',
                'client_id' => 'gateway',
                'username' => 'mkt_655000_de',
                'password' => 'Laura2020!',
            ],
        ];
        $response = $this->client->request('POST', self::API_URL_AUTH, $requestOptions);

        if ((int)$response->getStatusCode() === 200) {
            $responseArray = json_decode($response->getBody()->getContents(), true);

            return $responseArray['access_token'];
        }

        return '';
    }



    public function getRegionTreeV2()
    {

        $requestModel = $this->mapper->mapRequestForRegionTreeV2();
        $requestJson = $this->serializer->serialize($requestModel,'json');

        $requestOptions = [
            'headers' => ['Authorization' => 'Bearer ' . $this->oauth2AccessToken(), 'content-type' => 'application/json'],
            'body' => $requestJson,
        ];

        try {
            $response = $this->client->request('POST', self::API_URL_PACKAGE, $requestOptions);

            return $this->serializer->deserialize($response->getBody()->getContents() , InventoryDataForPackageRS::class , 'json');

        } catch (ClientException $exception) {
            $logger = \Pimcore\Log\ApplicationLogger::getInstance("TTXmlWebService", true);
            $logger->alert('ERROR: While TT Post Request: ' . $exception->getMessage());

            return $exception;
        }



        $requestModel = $this->mapper->mapRequestForRegionTree();
        $requestXml = $this->serializer->serialize($requestModel, 'xml');

        $requestOptions = [
            'headers' => [],
            'auth'    => ['MKT_655000_DE', '193893Hjtt0!aaaqq', 'digest'],
            'body'    => $requestXml,
        ];

        try {
            /** @var ResponseInterface $response */
            $response = $this->client->request('POST', self::API_URI, $requestOptions);
            $result = $response->getBody()->getContents();

            return $this->serializer->deserialize($result, SearchEngineRegionTreeRS::class, 'xml');
        } catch (\Exception $exception) {
            // return false or null? or maybe do not catch exception in pimcore context?
            return $exception;
        }
    }
}
