<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\FlightResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Flight
 *
 * @package Vtours\TTXmlWebService\Model\Response\FlightResponse
 */
class Flight
{

    /**
     * @var FlightDateTimeSpan
     * @Serializer\Type("FlightDateTimeSpan")
     * @Serializer\SerializedName("FlightDateTimeSpan")
     */
    private $flightdateTimeSpan;

    /**
     * @var InAndOutboundFlightSegments
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\InAndOutboundFlightSegments")
     * @Serializer\SerializedName("OutboundFlightSegments")
     */
    private $outBoundFlightSegments;

    /**
     * @var InAndOutboundFlightSegments
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\InAndOutboundFlightSegments")
     * @Serializer\SerializedName("InboundFlightSegments")
     */
    private $inboundFlightSegmetns;

    /**
     * @var TermsAndConditions
     * @Serializer\Type("TermsAndConditions")
     * @Serializer\SerializedName("TermsAndConditions")
     */
    private $termsAndConditions;


    /**
     *
     * @return FlightDateTimeSpan
     */
    public function getFlightdateTimeSpan()
    {
        return $this->flightdateTimeSpan;
    }

    /**
     * @param FlightDateTimeSpan $flightdateTimeSpan
     *
     * @return Flight
     */
    public function setFlightdateTimeSpan($flightdateTimeSpan)
    {
        $this->flightdateTimeSpan = $flightdateTimeSpan;

        return $this;
    }

    /**
     * @return InAndOutboundFlightSegments
     */
    public function getOutBoundFlightSegments()
    {
        return $this->outBoundFlightSegments;
    }

    /**
     * @param InAndOutboundFlightSegments $outBoundFlightSegments
     *
     * @return Flight
     */
    public function setOutBoundFlightSegments($outBoundFlightSegments)
    {
        $this->outBoundFlightSegments = $outBoundFlightSegments;

        return $this;
    }

    /**
     * @return InAndOutboundFlightSegments
     */
    public function getInboundFlightSegmetns()
    {
        return $this->inboundFlightSegmetns;
    }

    /**
     * @param InAndOutboundFlightSegments $inboundFlightSegmetns
     *
     * @return Flight
     */
    public function setInboundFlightSegmetns($inboundFlightSegmetns)
    {
        $this->inboundFlightSegmetns = $inboundFlightSegmetns;

        return $this;
    }


    /**
     * @return TermsAndConditions
     */
    public function getTermsAndConditions()
    {
        return $this->termsAndConditions;
    }

    /**
     * @param TermsAndConditions $termsAndConditions
     *
     * @return Flight
     */
    public function setTermsAndConditions($termsAndConditions)
    {
        $this->termsAndConditions = $termsAndConditions;

        return $this;
    }
}
