<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SpecialJourneyAttributes
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class SpecialJourneyAttributes
{
    /**
     * @var Accommodation
     * @Serializer\Type("Accommodation")
     * @Serializer\SerializedName("Accommodation")
     */
    private $accommodation;

    /**
     * SpecialJourneyAttributes constructor.
     *
     * @param Accommodation $accommodation
     */
    public function __construct(Accommodation $accommodation)
    {
        $this->accommodation = $accommodation;
    }

    /**
     * @return Accommodation
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param Accommodation $accommodation
     *
     * @return SpecialJourneyAttributes
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;

        return $this;
    }
}
