<?php

namespace Vtours\TTXmlWebService\Model\Response\v2;

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;
use Vtours\TTXmlWebService\Model\Response\v2\RSMetaData;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;
use Vtours\TTXmlWebService\Model\Response\v2\StationDictionary;
use Vtours\TTXmlWebService\Model\Response\v2\Offers;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class AccommodationOffersRS
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\AccommodationOffersRS")
     * @Serializer\SerializedName("AccommodationOffersRS")
     *
     * @var AccommodationOffersRS
     */
    private $accommodationOffersRS;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\RSMetaData")
     * @Serializer\SerializedName("RS_Metadata")
     *
     * @var RSMetaData
     */
    private $RSMetadata;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary")
     * @Serializer\SerializedName("GeoDictionary")
     *
     * @var GeoDictionary
     */
    private $geoDictionary;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary")
     * @Serializer\SerializedName("HotelDictionary")
     *
     * @var HotelDictionary
     */
    private $hotelDictionary;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\StationDictionary")
     * @Serializer\SerializedName("StationDictionary")
     *
     * @var StationDictionary
     */
    private $stationDictionary;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers")
     * @Serializer\SerializedName("Offers")
     *
     * @var Offers
     */
    private $offers;

    /**
     * @return AccommodationOffersRS
     */
    public function getAccommodationOffersRS()
    {
        return $this->accommodationOffersRS;
    }

    /**
     * @param AccommodationOffersRS $accommodationOffersRS
     */
    public function setAccommodationOffersRS($accommodationOffersRS)
    {
        $this->accommodationOffersRS = $accommodationOffersRS;
    }

    /**
     * @return RSMetaData
     */
    public function getRSMetaData()
    {
        return $this->RSMetadata;
    }

    /**
     * @param RSMetaData $RSMetaData
     */
    public function setRSMetaData($RSMetaData)
    {
        $this->RSMetadata = $RSMetaData;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary
     */
    public function getGeoDictionary()
    {
        return $this->geoDictionary;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary $geoDictionary
     */
    public function setGeoDictionary($geoDictionary)
    {
        $this->geoDictionary = $geoDictionary;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary
     */
    public function getHotelDictionary()
    {
        return $this->hotelDictionary;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary $hotelDictionary
     */
    public function setHotelDictionary($hotelDictionary)
    {
        $this->hotelDictionary = $hotelDictionary;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\StationDictionary
     */
    public function getStationDictionary()
    {
        return $this->stationDictionary;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\StationDictionary $stationDictionary
     */
    public function setStationDictionary($stationDictionary)
    {
        $this->stationDictionary = $stationDictionary;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers
     */
    public function getOffers()
    {
        return $this->offers;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers $offers
     */
    public function setOffers($offers)
    {
        $this->offers = $offers;
    }
}
