<?php

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class City
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("CityID")
     *
     * @var integer
     */
    private $cityId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelCount")
     *
     * @var integer
     */
    private $hotelCount;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }

    /**
     * @param int $cityId
     */
    public function setCityId($cityId)
    {
        $this->cityId = $cityId;
    }

    /**
     * @return int
     */
    public function getHotelCount()
    {
        return $this->hotelCount;
    }

    /**
     * @param int $hotelCount
     */
    public function setHotelCount($hotelCount)
    {
        $this->hotelCount = $hotelCount;
    }
}
