<?php

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Continents;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Countries;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Cities;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Provinces;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionGroups;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Regions;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class GeoDictionary
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Continents")
     * @Serializer\SerializedName("Continents")
     *
     * @var Continents
     */
    private $continents;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Countries")
     * @Serializer\SerializedName("Countries")
     *
     * @var Countries
     */
    private $countries;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Provinces")
     * @Serializer\SerializedName("Provinces")
     *
     * @var Provinces
     */
    private $provinces;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionGroups")
     * @Serializer\SerializedName("RegionGroups")
     *
     * @var RegionGroups
     */
    private $regionGroups;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Regions")
     * @Serializer\SerializedName("Regions")
     *
     * @var Regions
     */
    private $regions;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Cities")
     * @Serializer\SerializedName("Cities")
     *
     * @var Cities
     */
    private $cities;

    /**
     * @return Continents
     */
    public function getContinents()
    {
        return $this->continents;
    }

    /**
     * @param Continents $continents
     */
    public function setContinents($continents)
    {
        $this->continents = $continents;
    }

    /**
     * @return Countries
     */
    public function getCountries()
    {
        return $this->countries;
    }

    /**
     * @param Countries $countries
     */
    public function setCountries($countries)
    {
        $this->countries = $countries;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Provinces
     */
    public function getProvinces()
    {
        return $this->provinces;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Provinces $provinces
     */
    public function setProvinces($provinces)
    {
        $this->provinces = $provinces;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionGroups
     */
    public function getRegionGroups()
    {
        return $this->regionGroups;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionGroups $regionGroups
     */
    public function setRegionGroups($regionGroups)
    {
        $this->regionGroups = $regionGroups;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Regions
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Regions $regions
     */
    public function setRegions($regions)
    {
        $this->regions = $regions;
    }

    /**
     * @return Cities
     */
    public function getCities()
    {
        return $this->cities;
    }

    /**
     * @param Cities $cities
     */
    public function setCities($cities)
    {
        $this->cities = $cities;
    }
}
