<?php
namespace Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Province;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Provinces
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Province>")
     * @Serializer\SerializedName("Province")
     *
     *
     * @var Province
     */
    private $province;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Province
     */
    public function getProvince()
    {
        return $this->province;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Province $province
     */
    public function setProvince($province)
    {
        $this->province = $province;
    }
}
