<?php
namespace Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionClimate;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Region
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\RegionClimate")
     * @Serializer\SerializedName("RegionClimate")
     *
     * @var RegionClimate
     */
    private $regionClimate;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("RegionID")
     *
     * @var integer
     */
    private $regionId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("RegionGroupID")
     *
     * @var integer
     */
    private $regionGroupId;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\RegionClimate
     */
    public function getRegionClimate()
    {
        return $this->regionClimate;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\RegionClimate $regionClimate
     */
    public function setRegionClimate($regionClimate)
    {
        $this->regionClimate = $regionClimate;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getRegionId()
    {
        return $this->regionId;
    }

    /**
     * @param int $regionId
     */
    public function setRegionId($regionId)
    {
        $this->regionId = $regionId;
    }

    /**
     * @return int
     */
    public function getRegionGroupId()
    {
        return $this->regionGroupId;
    }

    /**
     * @param int $regionGroupId
     */
    public function setRegionGroupId($regionGroupId)
    {
        $this->regionGroupId = $regionGroupId;
    }
}
