<?php
namespace Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameter;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class RegionClimate
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameter>")
     * @Serializer\SerializedName("ClimateParameter")
     *
     * @var ClimateParameter
     */
    private $climateParameter;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\ClimateParameter
     */
    public function getClimateParameter()
    {
        return $this->climateParameter;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameter $climateParameter
     */
    public function setClimateParameter($climateParameter)
    {
        $this->climateParameter = $climateParameter;
    }
}
