<?php
namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelCodes;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelReview;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelImages;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelGeoPoint;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Hotel
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef")
     * @Serializer\SerializedName("HotelLocationRef")
     *
     * @var HotelLocationRef
     */
    private $hotelLocationRef;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelCodes")
     * @Serializer\SerializedName("HotelCodes")
     *
     * @var HotelCodes
     */
    private $hotelCodes;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("array")
     * @Serializer\SerializedName("HotelAttributes")
     *
     * @var array
     */
    private $hotelAttributes;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("HotelCategory")
     *
     * @var float
     */
    private $hotelCategory;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelReview")
     * @Serializer\SerializedName("HotelReview")
     *
     * @var HotelReview
     */
    private $hotelReview;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelImages")
     * @Serializer\SerializedName("HotelImages")
     *
     * @var HotelImages
     */
    private $hotelImages;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelGeoPoint")
     * @Serializer\SerializedName("HotelGeoPoint")
     *
     * @var HotelGeoPoint
     */
    private $hotelGeoPoint;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelID")
     *
     * @var integer
     */
    private $hotelId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DynamicHotelID")
     *
     * @var bool
     */
    private $dynamicHotelId;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef
     */
    public function getHotelLocationRef()
    {
        return $this->hotelLocationRef;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef $hotelLocationRef
     */
    public function setHotelLocationRef($hotelLocationRef)
    {
        $this->hotelLocationRef = $hotelLocationRef;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelCodes
     */
    public function getHotelCodes()
    {
        return $this->hotelCodes;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelCodes $hotelCodes
     */
    public function setHotelCodes($hotelCodes)
    {
        $this->hotelCodes = $hotelCodes;
    }

    /**
     * @return array
     */
    public function getHotelAttributes()
    {
        return $this->hotelAttributes;
    }

    /**
     * @param array $hotelAttributes
     */
    public function setHotelAttributes($hotelAttributes)
    {
        $this->hotelAttributes = $hotelAttributes;
    }

    /**
     * @return array
     */
    public function getHotelCategory()
    {
        return $this->hotelCategory;
    }

    /**
     * @param array $hotelCategory
     */
    public function setHotelCategory($hotelCategory)
    {
        $this->hotelCategory = $hotelCategory;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef
     */
    public function getHotelReview()
    {
        return $this->hotelReview;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\HotelLocationRef $hotelReview
     */
    public function setHotelReview($hotelReview)
    {
        $this->hotelReview = $hotelReview;
    }

    /**
     * @return HotelImages
     */
    public function getHotelImages()
    {
        return $this->hotelImages;
    }

    /**
     * @param HotelImages $hotelImages
     */
    public function setHotelImages($hotelImages)
    {
        $this->hotelImages = $hotelImages;
    }

    /**
     * @return HotelGeoPoint
     */
    public function getHotelGeoPoint()
    {
        return $this->hotelGeoPoint;
    }

    /**
     * @param HotelGeoPoint $hotelGeoPoint
     */
    public function setHotelGeoPoint($hotelGeoPoint)
    {
        $this->hotelGeoPoint = $hotelGeoPoint;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getHotelId()
    {
        return $this->hotelId;
    }

    /**
     * @param int $hotelId
     */
    public function setHotelId($hotelId)
    {
        $this->hotelId = $hotelId;
    }

    /**
     * @return bool
     */
    public function isDynamicHotelId()
    {
        return $this->dynamicHotelId;
    }

    /**
     * @param bool $dynamicHotelId
     */
    public function setDynamicHotelId($dynamicHotelId)
    {
        $this->dynamicHotelId = $dynamicHotelId;
    }
}
