<?php

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;

use Vtours\TTXmlWebService\Model\Response\v2\RSMetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class InventoryDataForPackageRS
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\InventoryDataForPackageRS")
     * @Serializer\SerializedName("InventoryDataForPackageRS")
     *
     * @var InventoryDataForPackageRS
     */
    private $inventoryDataForPackageRS;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\RSMetaData")
     * @Serializer\SerializedName("RS_Metadata")
     *
     * @var RSMetaData
     */
    private $RSMetadata;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\RegionGroups")
     * @Serializer\SerializedName("RegionGroups")
     *
     * @var RegionGroups
     */
    private $regionGroups;

    /**
     * @return InventoryDataForPackageRS
     */
    public function getInventoryDataForPackageRS()
    {
        return $this->inventoryDataForPackageRS;
    }

    /**
     * @param InventoryDataForPackageRS $inventoryDataForPackageRS
     */
    public function setInventoryDataForPackageRS($inventoryDataForPackageRS)
    {
        $this->inventoryDataForPackageRS = $inventoryDataForPackageRS;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\RSMetaData
     */
    public function getRSMetadata()
    {
        return $this->RSMetadata;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\RSMetaData $RSMetadata
     */
    public function setRSMetadata($RSMetadata)
    {
        $this->RSMetadata = $RSMetadata;
    }

    /**
     * @return RegionGroups
     */
    public function getRegionGroups()
    {
        return $this->regionGroups;
    }

    /**
     * @param RegionGroups $regionGroups
     */
    public function setRegionGroups($regionGroups)
    {
        $this->regionGroups = $regionGroups;
    }
}
