<?php

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;

use Vtours\TTXmlWebService\Model\Response\v2\Offers\Offer;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Offers
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\Offers\Offer>")
     * @Serializer\SerializedName("Offer")
     *
     * @var Offer
     */
    private $offer;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("OfferCount")
     *
     * @var integer
     */
    private $offerCount;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("MoreOffersAvailable")
     *
     * @var integer
     */
    private $moreOffersAvailable;

    /**
     * @return Offer
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Offer $offer
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;
    }

    /**
     * @return int
     */
    public function getOfferCount()
    {
        return $this->offerCount;
    }

    /**
     * @param int $offerCount
     */
    public function setOfferCount($offerCount)
    {
        $this->offerCount = $offerCount;
    }

    /**
     * @return int
     */
    public function getMoreOffersAvailable()
    {
        return $this->moreOffersAvailable;
    }

    /**
     * @param int $moreOffersAvailable
     */
    public function setMoreOffersAvailable($moreOffersAvailable)
    {
        $this->moreOffersAvailable = $moreOffersAvailable;
    }
}
