<?php

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\Room;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\HotelRef;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Accommodation
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\HotelRef")
     * @Serializer\SerializedName("HotelRef")
     *
     * @var HotelRef
     */
    private $hotelRef;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ServiceCode")
     *
     * @var string
     */
    private $serviceCode;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Room")
     * @Serializer\SerializedName("Room")
     *
     * @var Room
     */
    private $room;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("BoardType")
     *
     * @var string
     */
    private $boardType;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("HotelOfferCategory")
     *
     * @var float
     */
    private $hotelOfferCategory;

    /**
     * @return HotelRef
     */
    public function getHotelRef()
    {
        return $this->hotelRef;
    }

    /**
     * @param HotelRef $hotelRef
     */
    public function setHotelRef($hotelRef)
    {
        $this->hotelRef = $hotelRef;
    }

    /**
     * @return string
     */
    public function getServiceCode()
    {
        return $this->serviceCode;
    }

    /**
     * @param string $serviceCode
     */
    public function setServiceCode($serviceCode)
    {
        $this->serviceCode = $serviceCode;
    }

    /**
     * @return Room
     */
    public function getRoom()
    {
        return $this->room;
    }

    /**
     * @param Room $room
     */
    public function setRoom($room)
    {
        $this->room = $room;
    }

    /**
     * @return string
     */
    public function getBoardType()
    {
        return $this->boardType;
    }

    /**
     * @param string $boardType
     */
    public function setBoardType($boardType)
    {
        $this->boardType = $boardType;
    }

    /**
     * @return float
     */
    public function getHotelOfferCategory()
    {
        return $this->hotelOfferCategory;
    }

    /**
     * @param float $hotelOfferCategory
     */
    public function setHotelOfferCategory($hotelOfferCategory)
    {
        $this->hotelOfferCategory = $hotelOfferCategory;
    }
}
