<?php
namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\TourOperator;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\PriceInfo;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\TravelDateInfo;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferServices;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferProperties;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Offer
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferServices")
     * @Serializer\SerializedName("OfferServices")
     *
     * @var OfferServices
     */
    private $offerServices;
    
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\TravelDateInfo")
     * @Serializer\SerializedName("TravelDateInfo")
     *
     * @var TravelDateInfo
     */
    private $travelDateInfo;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\TourOperator")
     * @Serializer\SerializedName("TourOperator")
     *
     * @var TourOperator
     */
    private $tourOperator;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\PriceInfo")
     * @Serializer\SerializedName("PriceInfo")
     *
     * @var PriceInfo
     */
    private $priceInfo;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferProperties")
     * @Serializer\SerializedName("OfferProperties")
     *
     * @var OfferProperties
     */
    private $offerProperties;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DescriptionFetchKey")
     *
     * @var string
     */
    private $descriptionFetchKey;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("AccomStationDistance")
     *
     * @var string
     */
    private $accomStatonDistance;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("OfferID")
     *
     * @var string
     */
    private $offerId;

    /**
     * @return TravelDateInfo
     */
    public function getTravelDateInfo()
    {
        return $this->travelDateInfo;
    }

    /**
     * @param TravelDateInfo $travelDateInfo
     */
    public function setTravelDateInfo($travelDateInfo)
    {
        $this->travelDateInfo = $travelDateInfo;
    }

    /**
     * @return TourOperator
     */
    public function getTourOperator()
    {
        return $this->tourOperator;
    }

    /**
     * @param TourOperator $tourOperator
     */
    public function setTourOperator($tourOperator)
    {
        $this->tourOperator = $tourOperator;
    }

    /**
     * @return PriceInfo
     */
    public function getPriceInfo()
    {
        return $this->priceInfo;
    }

    /**
     * @param PriceInfo $priceInfo
     */
    public function setPriceInfo($priceInfo)
    {
        $this->priceInfo = $priceInfo;
    }

    /**
     * @return string
     */
    public function getDescriptionFetchKey()
    {
        return $this->descriptionFetchKey;
    }

    /**
     * @param string $descriptionFetchKey
     */
    public function setDescriptionFetchKey($descriptionFetchKey)
    {
        $this->descriptionFetchKey = $descriptionFetchKey;
    }

    /**
     * @return string
     */
    public function getAccomStatonDistance()
    {
        return $this->accomStatonDistance;
    }

    /**
     * @param string $accomStatonDistance
     */
    public function setAccomStatonDistance($accomStatonDistance)
    {
        $this->accomStatonDistance = $accomStatonDistance;
    }

    /**
     * @return string
     */
    public function getOfferId()
    {
        return $this->offerId;
    }

    /**
     * @param string $offerId
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferServices
     */
    public function getOfferServices()
    {
        return $this->offerServices;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\OfferServices $offerServices
     */
    public function setOfferServices($offerServices)
    {
        $this->offerServices = $offerServices;
    }

    /**
     * @return OfferProperties
     */
    public function getOfferProperties()
    {
        return $this->offerProperties;
    }

    /**
     * @param OfferProperties $offerProperties
     */
    public function setOfferProperties($offerProperties)
    {
        $this->offerProperties = $offerProperties;
    }
}
