<?php

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\Flight;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Package
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation")
     * @Serializer\SerializedName("Accommodation")
     *
     * @var Accommodation
     */
    private $accommodation;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Flight")
     * @Serializer\SerializedName("Flight")
     *
     * @var Flight
     */
    private $flight;

    /**
     * @return Accommodation
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param Accommodation $accommodation
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\Flight
     */
    public function getFlight()
    {
        return $this->flight;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\Flight $flight
     */
    public function setFlight($flight)
    {
        $this->flight = $flight;
    }
}
