<?php
namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

use Vtours\TTXmlWebService\Model\Response\v2\StationDictionary\Station;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class StationDictionary
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\StationDictionary\Station>")
     * @Serializer\SerializedName("Station")
     *
     * @var Station
     */
    private $station;

    /**
     * @return Station
     */
    public function getStation()
    {
        return $this->station;
    }

    /**
     * @param Station $station
     */
    public function setStation($station)
    {
        $this->station = $station;
    }
}
