<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2\AccommodationOffersRQ;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\v2\OfferTravellers;
use Vtours\TTXmlWebService\Model\Request\v2\OfferFilters;
use Vtours\TTXmlWebService\Model\Request\v2\OfferOptions;
use Vtours\TTXmlWebService\Model\Request\v2\RQMeta;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class AccommodationOfferRQ
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\RQMeta")
     * @Serializer\SerializedName("RQ_Metadata")
     *
     * @var RQMeta
     *
     */
    private $RQMeta;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CurrencyCode")
     *
     * @var string
     */
    private $currencyCode = "EUR";


    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferTravellers")
     * @Serializer\SerializedName("Travellers")
     *
     * @var OfferTravellers
     *
     */
    private $travellers;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters")
     * @Serializer\SerializedName("OfferFilters")
     *
     * @var OfferFilters
     *
     */
    private $offerFilters;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferOptions")
     * @Serializer\SerializedName("Options")
     *
     * @var OfferOptions
     */
    private $offerOptions;

    /**
     * @return RQMeta
     */
    public function getRQMeta()
    {
        return $this->RQMeta;
    }

    /**
     * @param RQMeta $RQMeta
     */
    public function setRQMeta($RQMeta)
    {
        $this->RQMeta = $RQMeta;
    }

    /**
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param string $currencyCode
     */
    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Request\v2\OfferTravellers
     */
    public function getTravellers()
    {
        return $this->travellers;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Request\v2\OfferTravellers $travellers
     */
    public function setTravellers($travellers)
    {
        $this->travellers = $travellers;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Request\v2\OfferFilters
     */
    public function getOfferFilters()
    {
        return $this->offerFilters;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Request\v2\OfferFilters $offerFilters
     */
    public function setOfferFilters($offerFilters)
    {
        $this->offerFilters = $offerFilters;
    }

    /**
     * @return OfferOptions
     */
    public function getOfferOptions()
    {
        return $this->offerOptions;
    }

    /**
     * @param OfferOptions $offerOptions
     */
    public function setOfferOptions($offerOptions)
    {
        $this->offerOptions = $offerOptions;
    }

    /**
     * @return AccommodationOffersRQ
     */
    public function getAccommodationOffersRQ()
    {
        return $this->packageOffersRQ;
    }

    /**
     * @param AccommodationOffersRQ $accommodationOffersRQ
     */
    public function setAccommodationOffersRQ($accommodationOffersRQ)
    {
        $this->accommodationOffersRQ = $accommodationOffersRQ;
    }


}
