<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\v2\PackageOffersRQ\PackageOffersRQ;


/**
 * @Serializer\ExclusionPolicy("all")
 */
class PackageOffersMainRQ
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\PackageOffersRQ\PackageOffersRQ")
     * @Serializer\SerializedName("PackageOffersRQ")
     *
     * @var PackageOffersRQ
     */
    private $packageOffersRQ;

    /**
     * @return PackageOffersRQ
     */
    public function getPackageOffersRQ()
    {
        return $this->packageOffersRQ;
    }

    /**
     * @param PackageOffersRQ $packageOffersRQ
     */
    public function setPackageOffersRQ($packageOffersRQ)
    {
        $this->packageOffersRQ = $packageOffersRQ;
    }
}
