<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class TravelDateInfo
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DepartureDate")
     *
     * @var string
     */
    private $departureDate;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReturnDate")
     *
     * @var string
     */
    private $returnDate;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TripDuration")
     *
     * @var integer
     */
    private $tripDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("StayDuration")
     *
     * @var integer
     */
    private $stayDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("BetweenDeparturesDuration")
     *
     * @var integer
     */
    private $betweenDeparturesDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("OvernightStays")
     *
     * @var integer
     */
    private $overnightStays;

    /**
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }

    /**
     * @param string $departureDate
     */
    public function setDepartureDate($departureDate)
    {
        $this->departureDate = $departureDate;
    }

    /**
     * @return string
     */
    public function getReturnDate()
    {
        return $this->returnDate;
    }

    /**
     * @param string $returnDate
     */
    public function setReturnDate($returnDate)
    {
        $this->returnDate = $returnDate;
    }

    /**
     * @return int
     */
    public function getTripDuration()
    {
        return $this->tripDuration;
    }

    /**
     * @param int $tripDuration
     */
    public function setTripDuration($tripDuration)
    {
        $this->tripDuration = $tripDuration;
    }

    /**
     * @return int
     */
    public function getStayDuration()
    {
        return $this->stayDuration;
    }

    /**
     * @param int $stayDuration
     */
    public function setStayDuration($stayDuration)
    {
        $this->stayDuration = $stayDuration;
    }

    /**
     * @return int
     */
    public function getBetweenDeparturesDuration()
    {
        return $this->betweenDeparturesDuration;
    }

    /**
     * @param int $betweenDeparturesDuration
     */
    public function setBetweenDeparturesDuration($betweenDeparturesDuration)
    {
        $this->betweenDeparturesDuration = $betweenDeparturesDuration;
    }

    /**
     * @return int
     */
    public function getOvernightStays()
    {
        return $this->overnightStays;
    }

    /**
     * @param int $overnightStays
     */
    public function setOvernightStays($overnightStays)
    {
        $this->overnightStays = $overnightStays;
    }

}
