<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Hotel
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest
 */
class Hotel
{
    /**
     * @var RoomType
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\RoomType")
     * @Serializer\SerializedName("RoomType")
     */
    private $roomType;

    /**
     * @var MealType
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\MealType")
     * @Serializer\SerializedName("MealType")
     */
    private $mealType;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("Category")
     */
    private $category;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry = "SpecialStayAttribute")
     * @Serializer\SerializedName("SpecialStayAttributes")
     */
    private $specialStayAttributes;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry = "HotelAttribute")
     * @Serializer\SerializedName("HotelAttributes")
     */
    private $hotelAttributes;

    /**
     * @var array<string>
     * @Serializer\Type("array<string>")
     * @Serializer\SerializedName("AdditionalAttributes")
     */
    private $additionalAttributes;

    /**
     * @return RoomType
     */
    public function getRoomType()
    {
        return $this->roomType;
    }

    /**
     * @param RoomType $roomType
     *
     * @return Hotel
     */
    public function setRoomType($roomType)
    {
        $this->roomType = $roomType;

        return $this;
    }

    /**
     * @return MealType
     */
    public function getMealType()
    {
        return $this->mealType;
    }

    /**
     * @param MealType $mealType
     *
     * @return Hotel
     */
    public function setMealType($mealType)
    {
        $this->mealType = $mealType;

        return $this;
    }

    /**
     * @return int
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @param int $category
     *
     * @return Hotel
     */
    public function setCategory($category)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return array
     */
    public function getSpecialStayAttributes()
    {
        return $this->specialStayAttributes;
    }

    /**
     * @param array $specialStayAttributes
     *
     * @return Hotel
     */
    public function setSpecialStayAttributes($specialStayAttributes)
    {
        $this->specialStayAttributes = $specialStayAttributes;

        return $this;
    }

    /**
     * @return array
     */
    public function getHotelAttributes()
    {
        return $this->hotelAttributes;
    }

    /**
     * @param array $hotelAttributes
     *
     * @return Hotel
     */
    public function setHotelAttributes($hotelAttributes)
    {
        $this->hotelAttributes = $hotelAttributes;

        return $this;
    }

    /**
     * @return array
     */
    public function getAdditionalAttributes()
    {
        return $this->additionalAttributes;
    }

    /**
     * @param array $additionalAttributes
     *
     * @return Hotel
     */
    public function setAdditionalAttributes($additionalAttributes)
    {
        $this->additionalAttributes = $additionalAttributes;

        return $this;
    }
}
