<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\v2\RQMeta;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class InventoryDataForAccommodationRQ
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\RQMeta")
     * @Serializer\SerializedName("RQ_Metadata")
     *
     * @var RQMeta
     *
     */
    private $RQMeta;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("array")
     * @Serializer\SerializedName("EntityKinds")
     *
     * @var array
     *
     */
    private $entityKinds = ['TouristicRegions'];

    /**
     * @return RQMeta
     */
    public function getRQMeta()
    {
        return $this->RQMeta;
    }

    /**
     * @param RQMeta $RQMeta
     */
    public function setRQMeta($RQMeta)
    {
        $this->RQMeta = $RQMeta;
    }

    /**
     * @return array
     */
    public function getEntityKinds()
    {
        return $this->entityKinds;
    }

    /**
     * @param array $entityKinds
     */
    public function setEntityKinds($entityKinds)
    {
        $this->entityKinds = $entityKinds;
    }

}
