<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */
namespace Vtours\TTXmlWebService\Model\Request\v2\OfferFilters;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class StationFilter
{
    /**
     * @Serializer\Expose()
     * @Serializer\SerializedName("DepartureStationFilter")
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\DepartureStationFilter")
     *
     * @var DepartureStationFilter
     */
    private $depatureStationFilter;

    /**
     * @return DepartureStationFilter
     */
    public function getDepatureStationFilter()
    {
        return $this->depatureStationFilter;
    }

    /**
     * @param DepartureStationFilter $depatureStationFilter
     */
    public function setDepatureStationFilter($depatureStationFilter)
    {
        $this->depatureStationFilter = $depatureStationFilter;
    }
}
