<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\FlightResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class TermsAndConditions
 *
 * @package Vtours\TTXmlWebService\Model\Response\FlightResponse
 */
class TermsAndConditions
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("URL")
     */
    private $url;

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     *
     * @return TermsAndConditions
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }
}
