<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class TourOperator
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class TourOperator
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Code")
     */
    private $code;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     */
    private $name;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Description")
     */
    private $description;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LogoURL")
     */
    private $logoUrl;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("HotelProvider")
     */
    private $hotelProvider;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightProvider")
     */
    private $flightProvider;

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     *
     * @return TourOperator
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return TourOperator
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return TourOperator
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return string
     */
    public function getLogoUrl()
    {
        return $this->logoUrl;
    }

    /**
     * @param string $logoUrl
     *
     * @return TourOperator
     */
    public function setLogoUrl($logoUrl)
    {
        $this->logoUrl = $logoUrl;

        return $this;
    }

    /**
     * @return string
     */
    public function getHotelProvider()
    {
        return $this->hotelProvider;
    }

    /**
     * @param string $hotelProvider
     *
     * @return TourOperator
     */
    public function setHotelProvider($hotelProvider)
    {
        $this->hotelProvider = $hotelProvider;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightProvider()
    {
        return $this->flightProvider;
    }

    /**
     * @param string $flightProvider
     *
     * @return TourOperator
     */
    public function setFlightProvider($flightProvider)
    {
        $this->flightProvider = $flightProvider;

        return $this;
    }
}
