<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\PriceResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class OriginalPrice
 *
 * @package Vtours\TTXmlWebService\Model\Response\PriceResponse
 */
class OriginalPrice
{
    /**
     * @var float
     * @Serializer\XmlValue()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("OriginalPrice")
     */
    private $originalPrice;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Currency")
     */
    private $currency;

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     *@param string $currency
     *
     * @return OriginalPrice
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }

    /**
     * @param mixed $originalPrice
     *
     * @return OriginalPrice
     */
    public function setOriginalPrice($originalPrice)
    {
        $this->originalPrice = $originalPrice;

        return $this;
    }
}
