<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\WeatherResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class YearOverview
 *
 * @package Vtours\TTXmlWebService\Model\Response\WeatherResponse
 */
class YearOverview
{

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ClimaDataType")
     */
    private $climaDataType;

    /**
     * @var ValueOfMonth
     * @Serializer\XmlList(inline = true, entry = "Vtours\TTXmlWebService\Model\Response\WeatherResponse\ValueOfMonth")
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\WeatherResponse\ValueOfMonth")
     * @Serializer\SerializedName("ValueOfMonth")
     */
    private $valueOfMonth;

    /**
     * @return ValueOfMonth
     */
    public function getValueOfMonth()
    {
        return $this->valueOfMonth;
    }

    /**
     * @param ValueOfMonth $valueOfMonth
     *
     * @return YearOverview
     */
    public function setValueOfMonth($valueOfMonth)
    {
        $this->valueOfMonth = $valueOfMonth;

        return $this;
    }

    /**
     * @return string
     */
    public function getClimaDataType()
    {
        return $this->climaDataType;
    }

    /**
     * @param string $climaDataType
     *
     * @return YearOverview
     */
    public function setClimaDataType($climaDataType)
    {
        $this->climaDataType = $climaDataType;

        return $this;
    }
}
