<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameterValue;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class ClimateParameter
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameterValue>")
     * @Serializer\SerializedName("ClimateParameterValue")
     *
     * @var ClimateParameterValue
     */
    private $climateParameterValue;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ClimateParameterType")
     *
     * @var string
     */
    private $climateParameterType;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\ClimateParameterValue
     */
    public function getClimateParameterValue()
    {
        return $this->climateParameterValue;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\ClimateParameterValue $climateParameterValue
     */
    public function setClimateParameterValue($climateParameterValue)
    {
        $this->climateParameterValue = $climateParameterValue;
    }

    /**
     * @return string
     */
    public function getClimateParameterType()
    {
        return $this->climateParameterType;
    }

    /**
     * @param string $climateParameterType
     */
    public function setClimateParameterType($climateParameterType)
    {
        $this->climateParameterType = $climateParameterType;
    }
}
