<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class HotelReview
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("RatingsCount")
     *
     * @var integer
     */
    private $ratingCount;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("MeanRatingOverall")
     *
     * @var integer
     */
    private $meanRatingOverall;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\MeanRatings")
     * @Serializer\SerializedName("MeanRatings")
     *
     * @var MeanRatings
     */
    private $meanRatings;


    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("MeanRecommendationRate")
     *
     * @var float
     */
    private $meanRecommendationRate;

    /**
     * @return int
     */
    public function getRatingCount()
    {
        return $this->ratingCount;
    }

    /**
     * @param int $ratingCount
     */
    public function setRatingCount($ratingCount)
    {
        $this->ratingCount = $ratingCount;
    }

    /**
     * @return int
     */
    public function getMeanRatingOverall()
    {
        return $this->meanRatingOverall;
    }

    /**
     * @param int $meanRatingOverall
     */
    public function setMeanRatingOverall($meanRatingOverall)
    {
        $this->meanRatingOverall = $meanRatingOverall;
    }

    /**
     * @return MeanRatings
     */
    public function getMeanRatings()
    {
        return $this->meanRatings;
    }

    /**
     * @param MeanRatings $meanRatings
     */
    public function setMeanRatings($meanRatings)
    {
        $this->meanRatings = $meanRatings;
    }

    /**
     * @return float
     */
    public function getMeanRecommendationRate()
    {
        return $this->meanRecommendationRate;
    }

    /**
     * @param float $meanRecommendationRate
     */
    public function setMeanRecommendationRate($meanRecommendationRate)
    {
        $this->meanRecommendationRate = $meanRecommendationRate;
    }
}
