<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class MeanRating
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("value")
     *
     * @var float
     */
    private $value;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("RatingAttribute")
     *
     * @var string
     */
    private $ratingAttribute;

    /**
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param float $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function getRatingAttribute()
    {
        return $this->ratingAttribute;
    }

    /**
     * @param string $ratingAttribute
     */
    public function setRatingAttribute($ratingAttribute)
    {
        $this->ratingAttribute = $ratingAttribute;
    }
}
